<?php
    /**
    *
    * copyright (c) 2013-2022 Heliac Technologies
    * license http://opensource.org/licenses/gpl-license.php GNU GPL v3 
    *
    * linee guida per l'utilizzo del logo http://www.geecom.org/index.php?alias=linee-guida-per-luso-del-logo-geecom
    *
    */

    include "../../include/includeBaseControllerComponenti.php";
    include "../../../../gUtil/GestoreUpload.php";
    include "../../../../gUtil/ElaboratoreImmagini.php";
    include "../classi/TabellaPrezzi.php";
    
    if(isset($_POST["operazione"])) {
        $operazione = filter_input(INPUT_POST,"operazione",FILTER_SANITIZE_STRING);
        $tabella = new TabellaPrezzi($geecomDb, filter_input(INPUT_POST, "id"));
    }
    else {
        $operazione = filter_input(INPUT_GET,"operazione",FILTER_SANITIZE_STRING);
        $tabella = new TabellaPrezzi($geecomDb, filter_input(INPUT_GET, "id"));
    }
    
    switch ($operazione) {
        case 'crea':
            $ordinabile = ($_POST["ordinabile"] == "si") ? "si" : "no";
            $tabella->setNome(filter_input(INPUT_POST,"nome",FILTER_SANITIZE_ADD_SLASHES));
            $tabella->setSpazioOccupato(filter_input(INPUT_POST,"spazioOccupato",FILTER_SANITIZE_STRING));
            $tabella->crea();
            header("Location: ../creaTabella.php?id={$tabella->getId()}&status=200");
            break;
        case 'modifica':
            $ordinabile = ($_POST["ordinabile"] == "si") ? "si" : "no";
            $tabella->setNome(filter_input(INPUT_POST,"nome",FILTER_SANITIZE_ADD_SLASHES));
            $tabella->setSpazioOccupato(filter_input(INPUT_POST,"spazioOccupato",FILTER_SANITIZE_STRING));
            $tabella->modifica();
            header("Location: ../creaTabella.php?id={$tabella->getId()}&status=250");
            break;
        case 'elimina':
            $tabella->elimina();
            echo "ok";
            break;
        case 'duplica':
            $tabella->caricaDatiDalDatabase();
            $idNuovaForm = $tabella->duplica();
            header("Location: ../creaTabella.php?id={$idNuovaForm}&status=260");
            break;
        case 'creaElemento':
            $nome        = filter_input(INPUT_POST,"nome",FILTER_SANITIZE_ADD_SLASHES);
            $descrizione = filter_input(INPUT_POST,"descrizione",FILTER_SANITIZE_ADD_SLASHES);
            $prezzo      = filter_input(INPUT_POST,"prezzo",FILTER_SANITIZE_STRING);
            $tabella->creaElemento($nome,$descrizione,$prezzo);
            echo "ok";
            break;
        case 'creaElementoColonna':
            $idColonna = filter_input(INPUT_POST,"idColonna",FILTER_SANITIZE_NUMBER_INT);
            $nome   = filter_input(INPUT_POST,"nome",FILTER_SANITIZE_ADD_SLASHES);
            $icona  = filter_input(INPUT_POST,"icona",FILTER_SANITIZE_STRING);
            $classe = filter_input(INPUT_POST,"classe",FILTER_SANITIZE_STRING);
            $tabella->creaElementoColonna($idColonna,$nome,$icona,$classe);
            echo "ok";
            break;
        case 'spostaElemento':
            $tabella->spostaElemento(filter_input(INPUT_POST, "idElemento",FILTER_SANITIZE_NUMBER_INT),filter_input(INPUT_POST, "posizione",FILTER_SANITIZE_NUMBER_INT));
            echo "ok";
            break;
        case 'spostaElementoColonna':
            $tabella->spostaElementoColonna(filter_input(INPUT_POST, "idColonna",FILTER_SANITIZE_NUMBER_INT),filter_input(INPUT_POST, "idElemento",FILTER_SANITIZE_NUMBER_INT),filter_input(INPUT_POST, "posizione",FILTER_SANITIZE_NUMBER_INT));
            echo "ok";
            break;
        case 'modificaElemento':
            $idElemento  = filter_input(INPUT_POST,"idElemento",FILTER_SANITIZE_STRING);
            $nome        = filter_input(INPUT_POST, 'nome', FILTER_SANITIZE_ADD_SLASHES);
            $descrizione = filter_input(INPUT_POST, 'descrizione', FILTER_SANITIZE_ADD_SLASHES);
            $prezzo      = str_replace(",",".",filter_input(INPUT_POST,"prezzo",FILTER_SANITIZE_STRING));
            $prezzoScontato = str_replace(",",".",filter_input(INPUT_POST,"prezzoScontato",FILTER_SANITIZE_STRING));
            $valuta   = filter_input(INPUT_POST, "valuta",FILTER_SANITIZE_STRING);
            $suffisso = filter_input(INPUT_POST, "suffisso",FILTER_SANITIZE_STRING);
            $link     = filter_input(INPUT_POST, "link",FILTER_SANITIZE_STRING);
            $etichettaLink = filter_input(INPUT_POST, 'etichettaLink', FILTER_SANITIZE_STRING);
            $preferita     = $geecomDb->escapeString(filter_input(INPUT_POST,"preferita"));
            
            $tabella->modificaElemento($idElemento,$nome, $descrizione, $prezzo,$prezzoScontato,$valuta,$suffisso,$link,$etichettaLink,$preferita);
            header("Location: ../creaElemento.php?id={$idElemento}&status=200");
            break;
        case 'duplicaElemento':
            $idElemento   = filter_input(INPUT_GET,"idElemento",FILTER_SANITIZE_STRING);
            $idNuovoElemento = $tabella->duplicaElemento($idElemento);
            header("Location: ../creaElemento.php?id={$idNuovoElemento}&status=200");
            break;
        case 'modificaElementoColonna':
            $idElemento  = filter_input(INPUT_POST,"idElemento",FILTER_SANITIZE_ADD_SLASHES);
            $nome   = filter_input(INPUT_POST, 'nome', FILTER_SANITIZE_ADD_SLASHES);
            $icona  = filter_input(INPUT_POST, "icona",FILTER_SANITIZE_STRING);
            $classe = filter_input(INPUT_POST, 'classe', FILTER_SANITIZE_STRING);
            
            $tabella->modificaElementoColonna($idElemento,$nome, $icona, $classe);
            echo "ok";
            break;
        case 'stampaElementi':
            $tabella->stampaElementi();
            break;
        case 'stampaElementiColonna':
            $idColonna = filter_input(INPUT_POST,"idColonna",FILTER_SANITIZE_STRING);
            $tabella->stampaElementiColonna($idColonna);
            break;
        case 'modificaImmagineElemento':
            $idElemento      = filter_input(INPUT_POST, "idElemento",FILTER_SANITIZE_NUMBER_INT);
            $tipiFileAmmessi = array("image/png","image/jpeg","image/gif");
            $gestoreUpload = new GestoreUpload("file", $tipiFileAmmessi, 8, "../../../../immagini/altro", 0);
            $esitoUpload  = $gestoreUpload->salvaFile();
            if($esitoUpload["fileElaborati"]==1) {
                if($esitoUpload["percorso"]!="") {
                    $percorsoFoto = str_replace("../","",$esitoUpload["percorso"]);
                }
                // se nelle impostazioni è spuintata la voce  "ottimizza immagini caricate" viene modificata
                if($impostazioni["ottimizzaImmaginiCaricate"]=="si") {
                    $elaboratoreImmagini = new ElaboratoreImmagini($esitoUpload["percorso"]);
                    if($elaboratoreImmagini->getAltezza()>$impostazioni["altezzaImmagine"]) {
                        $elaboratoreImmagini->modificaInScala("altezza", $impostazioni["altezzaImmagine"], $esitoUpload["percorso"]);
                    }
                }
            }
            else {
                $percorsoFoto = "";
            }
            $tabella->cambiaImmagineElemento($idElemento,$percorsoFoto);
            
            // se nelle impostazioni è spuintata la voce  "ottimizza immagini caricate" viene modificata
            if($impostazioni["ottimizzaImmaginiCaricate"]=="si") {
                $elaboratoreImmagini = new ElaboratoreImmagini($esitoUpload["percorso"]);
                if($elaboratoreImmagini->getAltezza()>$impostazioni["altezzaImmagine"]) {
                    $elaboratoreImmagini->modificaInScala("altezza", $impostazioni["altezzaImmagine"], $esitoUpload["percorso"]);
                }
            }

            if($impostazioni["generaThumbnail"]=="si") {
                $percorsoFileThumbnail = str_replace("immagini/","immagini/thumbnail/",$esitoUpload["percorso"]);
                $percorsoThumbnail = str_replace("../","",$percorsoFileThumbnail);
                $elaboratoreImmagini->modificaInScala("altezza", $impostazioni["altezzaThumbnail"], $percorsoFileThumbnail);
            }
            
            echo "../../../$percorsoFoto";
            break;
        case 'eliminaImmagineElemento':    
            $idElemento  = filter_input(INPUT_POST,"idElemento",FILTER_SANITIZE_STRING);
            $tabella->cambiaImmagineElemento($idElemento,"");
            echo "ok";
            break;
        case 'modificaImmagineElementoConPercorso':
            $idElemento = filter_input(INPUT_POST, "idElemento",FILTER_SANITIZE_NUMBER_INT);
            $percorso   = filter_input(INPUT_POST, "percorso",FILTER_SANITIZE_STRING);
            $tabella->cambiaImmagineElemento($idElemento,$percorso);
            echo "ok";
            break;
        case 'eliminaElemento':
            $tabella->eliminaElemento(filter_input(INPUT_POST, "idElemento",FILTER_SANITIZE_NUMBER_INT));
            echo "ok";
            break;
        case 'eliminaElementoColonna':
            $tabella->eliminaElementoColonna(filter_input(INPUT_POST, "idElemento",FILTER_SANITIZE_NUMBER_INT));
            echo "ok";
            break;
    }
